// // // // // // // // // // // // //
//
//	GameStatus
//
//	erstellt 4.12.97 von Andreas Warnke
//	geändert 28.4.97 von Andreas Warnke
//



// // // // // // // // // // // // //
//
//	include
//

#include <Window.h>
#include "GameStatus.h"
#include "AsciiKette.h"
#include "Definitions.h"
#include "Password.h"
#include "DigiMeter.h"



// // // // // // // // // // // // //
//
//	Scrollbar - Klasse:
//

class Scrr : public BScrollBar
{
private:
	BStringView * IntOut;
public:
	//	Konstruktor:
	Scrr( BStringView * inTarget ) : BScrollBar (
		BRect ( 80, 100 - B_H_SCROLL_BAR_HEIGHT, 349, 99 ),
		"Scroller",
		NULL,
		1,
		10,
		B_HORIZONTAL )
	{
		SetValue (10);
		IntOut = inTarget;
	};
	
	//	ValueChanged:
	virtual void ValueChanged ( float inValue )
	{
		if ( IntOut != NULL )
		{
			char * dummy = IntToString ( int ( inValue ) );
			IntOut -> SetText ( dummy );
			if ( dummy != NULL )
				delete [] dummy;
		};
	};
};

 

// // // // // // // // // // // // //
//
//	Konstruktor
//

GameStatus :: GameStatus ( BRect inRect )
	: BWindow(
		inRect,
		"Enemy Territory Server",
		B_TITLED_WINDOW,
		B_NOT_RESIZABLE | /*B_NOT_MINIMIZABLE |*/ B_NOT_ZOOMABLE | B_WILL_DRAW)
{	
	//	Info-Button:
	BButton * sInfo = new BButton (
		BRect ( 300, 160, 379, 179 ),
		"info-button",
		"About",
		new BMessage ( B_ABOUT_REQUESTED ) );
	if ( sInfo != NULL )
	{
		sInfo -> SetTarget ( be_app );
		AddChild ( sInfo );
	};
	
	//	Anmeldung initialisieren:
	BStringView * dummy2 = new BStringView (
		BRect ( 20, 20, 199, 39 ),
		"Statictext2",
		"Registration Number:" );
	if ( dummy2 != NULL )
		AddChild ( dummy2 );
	DieAnmeldung = new BTextControl (
		BRect ( 20, 40, 379, 59 ),
		"Anmeldung",
		/*"Registration Number:",*/ NULL,
		NULL,
		new BMessage ( Msg_CheckPassword ) );
	if ( DieAnmeldung != NULL )
	{
		AddChild ( DieAnmeldung );
		DieAnmeldung -> MakeFocus (true);
		DieAnmeldung -> SetDivider ( 0 );
		DieAnmeldung -> SetAlignment ( B_ALIGN_LEFT, B_ALIGN_LEFT );
	};
	
	//	MApsize initialisieren:
	DieSize = new BStringView (
		BRect ( 350, 80, 379, 99 ),
		"Size",
		NULL );
	if ( DieSize != NULL )
	{
		AddChild ( DieSize );
		DieSize -> SetAlignment ( B_ALIGN_RIGHT );
	};
	DerScroller = new Scrr( DieSize );
	if ( DerScroller != NULL ) 
		AddChild ( DerScroller );
	BStringView * dummy = new BStringView (
		BRect ( 20, 80, 79, 99 ),
		"Statictext",
		"Mapsize:" );
	if ( dummy != NULL )
		AddChild ( dummy );
		
	//	Login-Button:
	DieLoginSperre = new BCheckBox ( 
		BRect ( 20, 120, 139, 139 ),
		"DieLoginSperre",
		"Login disabled",
		NULL );
	if ( DieLoginSperre != NULL )
		AddChild ( DieLoginSperre );
		
	//	Pause-Button:
	/*DiePause = new BCheckBox ( 
		BRect ( 140, 120, 259, 139 ),
		"DiePause",
		"Game paused",
		NULL );
	if ( DiePause != NULL )
	{
		DiePause -> SetEnabled ( false );
		AddChild ( DiePause );
	};*/
		
	//	DigiMeter:
	ThePortMeter = new PortMeter ( 
		BRect ( 260, 120, 379, 139 ),
		"PortMeter",
		2,
		4,
		6 );
	if ( ThePortMeter != NULL )
		AddChild ( ThePortMeter );
		
	//	Status-Line
	DerStatus = new BStringView (
		BRect ( 20, 160, 294, 179 ),
		"StatusLine",
		"Status: Waiting for login." );
	if ( DerStatus != NULL )
		AddChild ( DerStatus );
		
	//	Grund:
	BView * sView = new BView (
		Bounds(),
		"Grund",
		B_FOLLOW_ALL_SIDES,
		B_WILL_DRAW );
	if ( sView != NULL )
	{
		sView -> SetViewColor ( 0xdd, 0xdd, 0xdd );
		AddChild ( sView );
	};

	//	Pulse:
	SetPulseRate ( 1000000 );
	
	//	Anzeige:
	Show ();
	
	//	Passwort auslesen:
	ReadPasswordFromFile ();
	PasswordCheck ();
};



// // // // // // // // // // // // //
//
//	Destruktor
//

GameStatus :: ~GameStatus ()
{
	//	Controls löschen:
	DieAnmeldung = NULL;
	DerScroller = NULL;
};



// // // // // // // // // // // // //
//
//	GameStatus -> Quit-Button
//

bool GameStatus :: QuitRequested()
{
	//	Beenden der be_app
	//	Beenden in jeden Fall! // if ( be_app -> CountWindows() == 1 )
	be_app -> PostMessage(B_QUIT_REQUESTED);	
	return(true);
};



// // // // // // // // // // // // //
//
//	GameStatus -> Message-Handler
//

void GameStatus :: MessageReceived ( BMessage * inMessage )
{
	if ( inMessage -> what == B_ABOUT_REQUESTED )
	{
		//	info:
		BAlert * sHi = new BAlert (
			"Willkommen",
			"Enemy Territory\n"
			"\n"
			"Server version: 1.0.3\n"
			"Protocol version: 1\n"
			"\n"
			"developed by Andreas Warnke\n"
			"awarnke@cip.informatik.uni-wuerzburg.de\n",
			"Great!" );
		if ( sHi != NULL )
			sHi -> Go ( NULL );
	}
	else if ( inMessage -> what == Msg_CheckPassword )
	{
		snooze ( 100000 );
		PasswordCheck ();
		WritePasswordToFile ();
	}
	else
		BWindow :: MessageReceived ( inMessage );
};



// // // // // // // // // // // // //
//
//	GameStatus -> GetSizeAndLock
//

int GameStatus :: GetSizeAndLock ()
{
	int sErg = 8;
	
	Lock();
	
	if ( DerScroller != NULL )
	{
		sErg = DerScroller -> Value ();
		DerScroller -> SetRange ( sErg, sErg );
	};
	
	/*if ( DieAnmeldung != NULL )
	{
		DieAnmeldung -> MakeFocus ( false );
		DieAnmeldung -> SetEnabled ( false );
	};*/
	
	Unlock ();
	
	//	fertig.
	return sErg;
};



// // // // // // // // // // // // //
//
//	PasswordCheck
//

void GameStatus :: PasswordCheck ()
{
	//	Parametercheck:
	if ( ( DieAnmeldung == NULL ) || ( DerScroller == NULL ) )
		return;
		
	//	Ist Scroller gedisabled?
	float sLow;
	float sHigh;
	DerScroller -> GetRange ( & sLow, & sHigh );
	if ( sLow == sHigh )
		return;
		
	//	Setze korrekten Wert:
	Lock ();
	if ( CheckPassword ( DieAnmeldung -> Text () ) )
	{
		DerScroller -> SetRange ( 1, 40 );
		DerScroller -> SetValue ( 20 );
	}
	else
	{
		if ( DerScroller -> Value () > 10 )
			DerScroller -> SetValue ( 10 );
		DerScroller -> SetRange ( 1, 10 );
	};	
	Unlock ();
};



// // // // // // // // // // // // //
//
//	GetloginSperre
//

int GameStatus :: GetLoginSperre ()
{
	if ( DieLoginSperre == NULL )
		return 0;
	else
		return DieLoginSperre -> Value ();
};



// // // // // // // // // // // // //
//
//	SetAndDisableLoginSperre
//

void GameStatus :: SetAndDisableLoginSperre ()
{
	if ( DieLoginSperre != NULL )
	{
		Lock ();
		DieLoginSperre -> SetValue ( 1 );
		DieLoginSperre -> SetEnabled ( false );
		Unlock ();
	};
};



// // // // // // // // // // // // //
//
//	GetPaused
//

/*int GameStatus :: GetPaused ()
{
	if ( DiePause == NULL )
		return 0;
	else
		return DiePause -> Value ();
};*/



// // // // // // // // // // // // //
//
//	SetStatusLine
//

void GameStatus :: SetStatusLine ( const char * inText )
{
	Lock ();
	if ( DerStatus != NULL )
		DerStatus -> SetText ( inText );
	Unlock ();
};



// // // // // // // // // // // // //
//
//	ReadPasswordFromFile
//

void GameStatus :: ReadPasswordFromFile ()
{
	//	Parametercheck:
	if ( DieAnmeldung == NULL )
		return;

	//	Erstelle das Path-Objekt:
	BPath sPathToSettings;
	if ( find_directory (
		B_USER_SETTINGS_DIRECTORY,
		& sPathToSettings,
		false ) < B_NO_ERROR )
		//	Das Verzeichnis existiert nicht.
		return;
	sPathToSettings . Append ( "Enemy Territory Password" );
	
	//	Erstelle das File-Objekt:
	BFile sFile ( sPathToSettings . Path (), B_READ_ONLY );
	if ( sFile . InitCheck () < B_NO_ERROR )
	{
		Lock ();
		DieAnmeldung -> SetText ( "This version is freeware." );
		Unlock ();
		return;
	}
		
	//	Bestimme Dateigröße:
	off_t sFileSize;
	sFile . GetSize ( & sFileSize );
	if ( sFileSize > 1024 )
		return;
		
	//	lies die Datei aus:
	char * sBuffer = new char [sFileSize + 1];
	if ( sFile . Read ( sBuffer, sFileSize ) != sFileSize )
	{
		//	Fehler.
		delete [] sBuffer;
		return;
	};
	sBuffer [sFileSize] = 0;
	
	//	Setze Passwort-String in der Anmeldung:
	Lock ();
	DieAnmeldung -> SetText ( sBuffer );
	Unlock ();
	
	//	fertig.
	delete [] sBuffer;
	return;
};



// // // // // // // // // // // // //
//
//	WritePasswordToFile
//

void GameStatus :: WritePasswordToFile ()
{
	return;
	//	Parametercheck:
	if ( DieAnmeldung == NULL )
		return;

	//	Erstelle das Path-Objekt:
	BPath sPathToSettings;
	if ( find_directory (
		B_USER_SETTINGS_DIRECTORY,
		& sPathToSettings,
		false ) < B_NO_ERROR )
		//	Das Verzeichnis existiert nicht.
		return;
	sPathToSettings . Append ( "Enemy Territory Password" );
	
	Lock ();
	const char * sPasswort = DieAnmeldung -> Text ();
	if ( CheckPassword ( sPasswort ) )
	{
		//	Das Passwort ist korrekt.

 		//	Erstelle das File-Objekt:
		BFile sFile (
			sPathToSettings . Path (),
			B_WRITE_ONLY | B_CREATE_FILE | B_ERASE_FILE );
		if ( sFile . InitCheck () < B_NO_ERROR )
		{
			Unlock ();
			return;
		};
			
		//	schreibe das Passwort:
		sFile . Write ( sPasswort, Length ( sPasswort ) );
		
		//	Setze den MIME-Type:
		BNodeInfo sMIMEFile ( & sFile );
		if ( sMIMEFile . InitCheck () >= B_NO_ERROR )
		{
			sMIMEFile . SetType ( "text/plain" );
			sMIMEFile . SetPreferredApp ( "application/x-vnd.Be-STEE" );
		};
	}
	else
	{
		//	Das Passwort ist falsch!
		
		//	Erstelle das Entry-Objekt:
		BEntry sEntry ( sPathToSettings . Path () );
		if ( sEntry . InitCheck () < B_NO_ERROR )
		{
			Unlock ();
			return;
		};
		
		//	lösche den Eintrag:
		sEntry . Remove ();
	};
	Unlock ();	
};



// // // // // // // // // // // // //
//
//	Hurry
//

bool GameStatus :: Hurry ()
{
	if ( ThePortMeter == NULL )
		return true;
	
	if ( ThePortMeter -> GetWaitingMessages () > ( B_LOOPER_PORT_DEFAULT_CAPACITY / 3 ) )
	{
		//	TimeOut displayed.
		//	Check:
		Lock ();
		ThePortMeter -> Pulse ();
		Unlock ();
	};
	return ( ThePortMeter -> GetWaitingMessages () > ( B_LOOPER_PORT_DEFAULT_CAPACITY / 3 ) );
};



//
//	Ende
//
// // // // // // // // // // // // //